% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_count.R
\name{simulate_count}
\alias{simulate_count}
\alias{sim_count}
\alias{sim_count_from_data}
\title{Simulate a random UMI count matrix}
\usage{
sim_count(depth, ratio, lfc = 0L, theta = 100L)

sim_count_from_data(reference, lfc = 0, theta = 100L, ngenes = NULL)
}
\arguments{
\item{depth}{simulated cells total UMI count}

\item{ratio}{ratio of genes UMI to be simulated}

\item{lfc}{log2 fold-change effect to be applied to the simulated cells}

\item{theta}{genes' dispersion parameter}

\item{reference}{a count matrix to base the simulation}

\item{ngenes}{number of genes to be simulated. When \code{NULL} it replicates
the gene ratio found in \code{reference}, otherwise it simulates \code{ngenes}
with ratio ranging in a logarithm scale from lowest to highest observed
ratio observed.}
}
\value{
random UMI count matrix
}
\description{
It generates a random UMI count matrix based on \strong{DECAL} model assumptions
given the cells total count (\code{depth}) and gene prevalence ratio (ratio of
genes UMIs over the total; \code{ratio}).
Alternatively, you can further specify the generative model, by giving a
log2 fold-change (\code{lfc}) effect and each gene dispersion (\code{theta}).
}
